<?php
require __DIR__ . '/vendor/autoload.php';
require "config.php";

use MercadoPago\MercadoPagoConfig;
use MercadoPago\Client\Payment\PaymentClient;

// Configurar token do Mercado Pago a partir da variável de ambiente
MercadoPagoConfig::setAccessToken($mercadoPagoAccessToken);

// Captura corpo da notificação
$input = json_decode(file_get_contents("php://input"), true);

// Verifica se o evento é do tipo esperado (exemplo: payment.updated)
// Se não tiver o campo 'action' no webhook, adapte conforme necessário
$action = $input['action'] ?? '';
if ($action !== 'payment.updated') {
    // Evento diferente, não faz nada
    http_response_code(200);
    include __DIR__ . '/errordocument/404.php';
    exit;
}

if (!isset($input['data']['id'])) {
    http_response_code(400);
    include __DIR__ . '/errordocument/400.php';
    exit;
}

$paymentId = $input['data']['id'];

// Buscar status real no Mercado Pago
$client = new PaymentClient();
$payment = $client->get($paymentId);

$status = $payment->status; // "pending", "approved", "cancelled", etc.
$date   = date("Y-m-d H:i:s");

// Mapear status Mercado Pago para nosso banco (inteiros)
if ($status === "approved") {
    $newStatus = 1;  // pago/completado
    $paid = 2;
    $atPayment = $date;
} elseif (in_array($status, ["cancelled", "rejected", "expired"])) {
    $newStatus = 1;  // cancelado
    $paid = 1;
    $atPayment = null;
} else {
    $newStatus = 0;  // pendente ou outro
    $paid = 0;
    $atPayment = null;
}

// Verifica se o QR code está disponível para evitar erro
$qrCode = $payment->point_of_interaction->transaction_data->qr_code ?? null;
if (!$qrCode) {
    http_response_code(400);
    include __DIR__ . '/errordocument/400.php';
    exit;
}

// Atualizar banco
$stmt = $pdo->prepare("UPDATE payments 
                       SET status = ?, paid = ?, at_payment_update = ? 
                       WHERE pix_code = ?");
$stmt->execute([$newStatus, $paid, $atPayment, $qrCode]);

http_response_code(200);
echo "OK";
?>