CREATE TABLE payments (
    id INT AUTO_INCREMENT PRIMARY KEY,
    account_id INT UNSIGNED NOT NULL,
    uuid CHAR(36) UNIQUE NOT NULL,
    status TINYINT NOT NULL DEFAULT 0,
    value INT NOT NULL,
    reward_item INT DEFAULT 0,
    reference VARCHAR(9) UNIQUE NOT NULL,
    pix_code TEXT,
    qr_code LONGTEXT,
    expire DATETIME,
    paid TINYINT(1) NOT NULL DEFAULT 0,
    mp_payment_id VARCHAR(255) UNIQUE,
    at_payment DATETIME DEFAULT CURRENT_TIMESTAMP,
    at_payment_update DATETIME ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_account_id (account_id),
    INDEX idx_uuid (uuid),
    INDEX idx_mp_payment_id (mp_payment_id)
) ENGINE=InnoDB;

CREATE TABLE payments_names (
    account_id INT UNSIGNED NOT NULL,
    fullname VARCHAR(150) NOT NULL,
    email VARCHAR(150) NOT NULL,
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    updated_at DATETIME ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (account_id),
    UNIQUE KEY uq_accountid (account_id),
    INDEX idx_email (email)
) ENGINE=InnoDB;