<?php
http_response_code(401);
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8" />
    <title>401 - Não Autorizado</title>
    <style>
        body {
		font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
		background: #f8f9fa;
		color: #333;
		display: flex;
		justify-content: center;
		align-items: center;
		height: 100vh;
		margin: 0;
		padding: 2rem;
	}
	
	.container {
		background: white;
		padding: 3rem;
		border-radius: 12px;
		box-shadow: 0 4px 6px rgba(0,0,0,0.1);
		text-align: center;
		max-width: 600px;
		width: 100%;
		box-sizing: border-box;
	}
	
	.code {
		font-size: 6rem;
		font-weight: 700;
		color: #e63946;
		margin-bottom: 1rem;
		opacity: 0.8;
	}
	
	h1 {
		margin-bottom: 1rem;
		font-weight: 600;
		color: #2b2d42;
	}
	
	p {
		color: #6c757d;
		font-size: 1.1rem;
	}
	
	/* Responsividade */
	@media (max-width: 768px) {
		.container {
			padding: 2rem 1.5rem;
			max-width: 90%;
		}
		.code {
			font-size: 4rem;
		}
		p {
			font-size: 1rem;
		}
	}
	
	@media (max-width: 400px) {
		.container {
			padding: 1.5rem 1rem;
		}
		.code {
			font-size: 3rem;
		}
		h1 {
			font-size: 1.4rem;
		}
		p {
			font-size: 0.9rem;
		}
	}
    </style>
</head>
<body>
    <div class="container">
        <div class="code">401</div>
        <h1>Não Autorizado</h1>
        <p>Você precisa estar autenticado para acessar este recurso. Faça login para continuar.</p>
    </div>
</body>
</html>